/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.payroll.bonus.dto;

import java.util.Date;

import jp.mosp.common.common.BaseDto;

public class PmUserDto extends BaseDto {
	
	private static final long serialVersionUID = 1583650239702032294L;
	
	// tB[h
	private String userId;
	private String password;
	private String kCode;
	private String userName;
	private String authority;
	private int    dataLevel;
	private Date   changePass;
	private int    deleteFlag;
	
	/**
	 * RXgN^
	 */
	public PmUserDto(){
		super();
	}
	
	/**
	 * RXgN^
	 */
	public PmUserDto(PmBasisDto dto){
		super();
		this.userId     = dto.getKCode();
		this.kCode      = dto.getKCode();
		this.userName   = dto.getKName();
	}
	
	// ANZT\bh
	public String getUserId() { return userId; }
	public void setUserId(String userId) { this.userId = userId; }
	public String getPassword() { return password; }
	public void setPassword(String password) { this.password = password; }
	public String getKCode() { return kCode; }
	public void setKCode(String kCode) { this.kCode = kCode; }
	public String getUserName() { return userName; }
	public void setUserName(String userName) { this.userName = userName; }
	public String getAuthority() { return authority; }
	public void setAuthority(String authority) { this.authority = authority; }
	public int getDataLevel() { return dataLevel; }
	public void setDataLevel(int dataLevel) { this.dataLevel = dataLevel; }
	public Date getChangePass() { return (Date)changePass.clone(); }
	public void setChangePass(Date changePass) { this.changePass = (Date)changePass.clone(); }
	public int getDeleteFlag() { return deleteFlag; }
	public void setDeleteFlag(int deleteFlag) { this.deleteFlag = deleteFlag; }
	
}
